//=========================================================================
//	CSceneMeshNX [ sceneMesh.cpp ]
//	쐬F2017/05/02
//	쐬ҁF
//=========================================================================
//=========================================================================
//	CN[ht@C
//=========================================================================
#include	"k_field.h"
#include	"manager.h"
#include	"renderer.h"
#include	"camera.h"
#include	"light.h"

//=========================================================================
//	萔`
//=========================================================================
#define	TEXTURE_NAME ("data/TEXTURE/field001.jpg")

//=========================================================================
//	O[oϐ
//=========================================================================
float	g_FieldHeight[ 11 ][ 11 ] =
{
	0
};

/*
//=========================================================================
//	CXgN^
//=========================================================================
KField::KField( int sheetTate , int sheetYoko , D3DXVECTOR3 Size )
{
	
}
*/

//=========================================================================
//	
//=========================================================================
void	KField::Init( void )
{
	//hrɊ֐͂Ă̂ŁAFAILED}NɓΉɒȂȂ
	if( FAILED( D3DXCreateTextureFromFile( CRenderer::GetDevice() , TEXTURE_NAME , &m_pTexture ) ) )
	{	//FALED}N@s𔻒f
		UINT nID = MessageBox( NULL , "|St@Cǂݍ߂܂\n" , "ERROR[ k_field.cpp ]" , MB_OK | MB_ICONEXCLAMATION );		
	}
	//FAILED}NŃG[`FbN

	//Sʒu
	SetPosition( D3DXVECTOR3( 0 , 0 , 0 ) );
	//傫
	SetSize( D3DXVECTOR3( 50.0f , 0.0f , 50.0f ) );

	SetSheet( 10.0f , 10.0f );

	float fLengthYoko = GetSize().x;
	float fLengthTate = GetSize().z;
	unsigned int nFieldYoko = ( unsigned int )GetSheet().x;
	unsigned int nFieldTate = ( unsigned int )GetSheet().z;

	m_pIndexBuffer = NULL;

	//Ίp̒
	SetLength( sqrtf( ( fLengthYoko * nFieldYoko ) * ( fLengthTate * nFieldTate) /*/ 2*/ ) /*/ 2*/);

	SetAngle( (atan2f( fLengthTate * nFieldTate , fLengthYoko * nFieldYoko ) ) );

	//tB[h̍
	SetStartPos( D3DXVECTOR3( -(GetLength() * cosf( GetAngle() )) , 0.0f , ( GetLength() * sinf( GetAngle() ) ) /2 ) );

	SetNumVertex( ( nFieldTate + 1 ) * ( nFieldYoko + 1 ) );

	SetNumIndex( ( ( nFieldYoko +1 ) * ( nFieldTate +1 ) ) * 2 -4 );

	SetNumPolygon( GetNumIndex() -2 );

	MakeVertex( CRenderer::GetDevice() );
}

//=========================================================================
//	I
//=========================================================================
void	KField::Uninit( void )
{
	if(m_pVtxBuffer != NULL)
	{
		m_pVtxBuffer->Release();
		m_pVtxBuffer = NULL;
	}

	if(m_pTexture != NULL)
	{
		m_pTexture->Release();
		m_pTexture = NULL;
	}

	if( m_pIndexBuffer != NULL )
	{
		m_pIndexBuffer->Release();
		m_pIndexBuffer = NULL;
	}
}

//=========================================================================
//	XV
//=========================================================================
void	KField::Update( void )
{/*ωȂ̂Ŗ*/}

//=========================================================================
//	`揈
//=========================================================================
void	KField::Draw( void )
{

	D3DXMATRIX	mtxWorld;	//[h}gNX
	D3DXMatrixIdentity( &mtxWorld );

	//g̏
	D3DXMATRIX	mtxKakudai;	//gs
	D3DXMatrixScaling( &mtxKakudai , 1.0f , 1.0f , 1.0f );

	//]̏
	D3DXMATRIX	mtxKaiten;	//]s
	D3DXMatrixRotationYawPitchRoll( &mtxKaiten , 0.0f , 0.0f , 0.0f );	
	
	D3DXMATRIX	mtxHeikou;	//sړs
	D3DXMatrixTranslation( &mtxHeikou , 0.0f , 0.0f , 0.0f );

	//s̊|Z
	D3DXMatrixMultiply( &mtxWorld , &mtxWorld , &mtxKakudai );	
	D3DXMatrixMultiply( &mtxWorld , &mtxWorld , &mtxKaiten );	
	D3DXMatrixMultiply( &mtxWorld , &mtxWorld , &mtxHeikou );	

	//foCXɃ[hϊso^
	CRenderer::GetDevice()->SetTransform( D3DTS_WORLD , &mtxWorld );

	//r[s̍쐬
	D3DXMATRIX	mtxView = CManager::GetCamera()->GetView();

	//foCXɃr[ϊsݒ
	CRenderer::GetDevice()->SetTransform( D3DTS_VIEW , &mtxView);

	//Cg̐ݒ
	CRenderer::GetDevice()->SetLight( 0, &CManager::GetLight()->GetLight() );

	//CManager::GetLight()->OnLight();

	CRenderer::GetDevice()->SetStreamSource( 0 , m_pVtxBuffer , 0 , sizeof(VERTEX_3D) );

	CRenderer::GetDevice()->SetIndices( m_pIndexBuffer );

	CRenderer::GetDevice()->SetFVF( FVF_VERTEX_3D );

	CRenderer::GetDevice()->SetTexture( 0,  m_pTexture );

	//|S̕`
	CRenderer::GetDevice()->DrawIndexedPrimitive( 
		D3DPT_TRIANGLESTRIP ,
		0 , //ŏ̒_CfbNX܂ł̃ItZbg
		0 , //ŏ_CfbNX
		GetNumIndex() ,	//_
		0 , //X^[gCfbNX
		GetNumPolygon() //v~eBu
	 );

	CManager::GetLight()->OnLight();
}

//=========================================================================
//	_̕ҏW
//=========================================================================
HRESULT	KField::MakeVertex( LPDIRECT3DDEVICE9 pDevice )
{
	unsigned int nFieldTate = ( unsigned int )GetSheet().z;
	unsigned int nFieldYoko = ( unsigned int )GetSheet().x;

	float	fLengthTate = GetSize().z;
	float	fLengthYoko = GetSize().x;

	//_obt@̐
	//FALED}Nł
	if( FAILED(pDevice->CreateVertexBuffer( sizeof(VERTEX_3D) * GetNumVertex() , //mۂobt@TCY(byte)
											D3DUSAGE_WRITEONLY , //̎gp@  Ƃ肠ꂾĂΑ@G`̂
											FVF_VERTEX_3D , //gp钸_tH[}bg ł͂Oőv
											D3DPOOL_MANAGED , //obt@̊Ǘ@@̂͂܂̂
											&m_pVtxBuffer , //|C^̊i[
											NULL ))) //Ȃ񂾂킩Ȃ)
	{										
		UINT nID = MessageBox( NULL , "_obt@ł܂\n" , "ERROR[ k_field.cpp ]" , MB_OK | MB_ICONEXCLAMATION );		
		return E_FAIL;
	}

	//VERTEX_2D^̃|C^
	VERTEX_3D* pVtx = NULL;

	//obt@bNzAhX擾
	if(FAILED( m_pVtxBuffer->Lock( 0 , 0 , (void**)&pVtx , 0 ) ) )
	{
		UINT nID = MessageBox( NULL , "_obt@bNł܂\n" , "ERROR[ field.cpp ]" , MB_OK | MB_ICONEXCLAMATION );
		return E_FAIL;
	}

	
	//_W̐ݒ				 X		   Y		Z
	//ĉ
	for( unsigned int numTate = 0 ; numTate < nFieldTate+1 ; numTate++ )
	{
		for( unsigned int numYoko = 0 ; numYoko < nFieldYoko+1 ; numYoko++ )
		{
			pVtx[ numTate * ( nFieldYoko + 1 ) + numYoko ].pos = D3DXVECTOR3( GetStartPos().x + ( fLengthYoko * numYoko ) , g_FieldHeight[numTate][numYoko] , GetStartPos().z - ( numTate * fLengthTate ) );
			pVtx[ numTate * ( nFieldYoko + 1 ) + numYoko ].tex = D3DXVECTOR2( (float)numYoko , (float)numTate );
			pVtx[ numTate * ( nFieldYoko + 1 ) + numYoko ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );
		}
	}

	for( unsigned int numTate = 1 ; numTate < nFieldTate ; numTate++ )
	{
		//̂
		for( unsigned int numYoko = 1 ; numYoko < nFieldYoko ; numYoko++ )
		{
			
			D3DXVECTOR3	directionX;
			D3DXVECTOR3 directionZ;

			D3DXVECTOR3	normalX;
			D3DXVECTOR3	normalZ;

			D3DXVECTOR3 normal;

			directionX = pVtx[ numTate * ( nFieldYoko +1 ) + numYoko+1  ].pos - pVtx[ numTate * ( nFieldYoko +1 ) + numYoko -1 ].pos; 
			normalX.x = -directionX.y;
			normalX.y = directionX.x; 
			normalX.z = 0.0f;

			directionZ =  pVtx[ (numTate + 1 ) * ( nFieldTate +1 ) + numYoko ].pos - pVtx[( numTate -1 )* ( nFieldTate + 1  ) + numYoko  ].pos; 
			normalZ.x = -directionZ.y;
			normalZ.y = directionZ.x; 
			normalZ.z = 0.0f;

			normal =  normalX + normalZ;

			D3DXVec3Normalize( &normal , &normal );

			pVtx[ numTate * ( nFieldYoko + 1 ) + numYoko ].normal = normal;

			//
			
		}
	}

	m_pVtxBuffer->Unlock();
	
	//CfbNXobt@̍쐬
	if( pDevice->CreateIndexBuffer(
	sizeof( DWORD ) * GetNumIndex(),	//obt@(32ɂDWORDɂ)
	D3DUSAGE_WRITEONLY ,		//gp@tO
	D3DFMT_INDEX16 ,			//CfbNXtH[}bg
	D3DPOOL_MANAGED ,			//Ǘ@
	&m_pIndexBuffer ,		//CfbNXobt@[C^[tF[Xւ̃|C^̃AhX
	NULL ) )
	{
		UINT nID = MessageBox( NULL , "CfbNXobt@ł܂\n" , "ERROR[ field.cpp ]" , MB_YESNO | MB_ICONEXCLAMATION );		
		return E_FAIL;
	}


	
	WORD* pIdx;
	m_pIndexBuffer->Lock( 0 , 0 , (void**)&pIdx , 0 );	//̈Ӗ̓o[ebNXobt@[̂ƂƓ

	int	index = 0;
	for( unsigned int nCntZ = 0 ; nCntZ < nFieldYoko ; nCntZ++ )
	{
		if( nCntZ != 0  )
		{
			pIdx[ index ] = (nFieldYoko + 1) * nCntZ+ (nFieldYoko + 1);
			index++;
		}
		pIdx[ index ] = (nFieldYoko+1)  * ( nCntZ + 1 );
		index++;
		pIdx[ index ] = (nFieldYoko+1) * nCntZ ;
		index++;
	
		for( unsigned int nCntX = 0 ; nCntX < nFieldTate ; nCntX++ )
		{
			pIdx[ index ] = ( nFieldYoko + 1 ) * (nCntZ + 1) + (nCntX + 1);
			index++;
			pIdx[ index ] = ( nFieldYoko + 1 ) * nCntZ + (nCntX +1);
			index++;
		}
		if(nCntZ != (nFieldTate -1) )
		{
			pIdx[ index ] = nFieldYoko + ( nCntZ * (nFieldYoko+1) );
			index++;
 		}
	}

	m_pIndexBuffer->Unlock();
	

	return	S_OK;
}

//=========================================================================
//	tB[hƂ̓蔻
//=========================================================================
float	KField::Collision(	const D3DXVECTOR3& pos )
{
	//VERTEX_2D^̃|C^
	VERTEX_3D* pVtx = NULL;

	//obt@bNzAhX擾
	m_pVtxBuffer->Lock( 0 , 0 , (void**)&pVtx ,0 );	//̍ŏQɂOOw肷ƑS

	D3DXVECTOR3 p0 , p1 , p2;
	D3DXVECTOR3 v01, v20 , v12 ;
	D3DXVECTOR3 v0p, v1p , v2p;
	D3DXVECTOR3 vC0, vC1 , vC2;
	D3DXVECTOR3 vn;

	float	fReturnNum = 0.0f;

	//O
	for( int nTate = 0 ; nTate < ( int )GetSheet().z  ; nTate++ )
	{
		for( int nYoko = 0 ; nYoko < ( int )GetSheet().x  ; nYoko++ )
		{
			//̎Op`Ƃ̓蔻
			p0 = pVtx[ (int)GetSheet().x * ( nTate +1 ) + nYoko ].pos;
			p2 = pVtx[ (int)GetSheet().x * ( nTate ) + nYoko ].pos;
			p1 = pVtx[ (int)GetSheet().x * ( nTate ) + nYoko +1 ].pos;

			v01 = p1 - p0;
			v0p = pos - p0;

			D3DXVec3Cross( &vC0 , &v01 , &v0p );

			//px
			if( vC0.y >= 0.0f )
			{
				v12 = p2 - p1;
				v1p = pos - p1;
				D3DXVec3Cross( &vC1 , &v12 , &v1p );

				if( vC1.y >= 0.0f )
				{
					v20 = p0 - p2;
					v2p = pos- p2;
					D3DXVec3Cross( &vC2 , &v20 , &v2p );

					//܂ł璆Ă܁[
					if( vC2.y >= 0.0f )
					{
						D3DXVec3Cross( &vn , &v01 , &v20 );
						D3DXVec3Normalize( &vn , &vn );

						fReturnNum = p0.y - ( ( pos.x - p0.x ) * vn.x + ( pos.z - p0.z ) * vn.z ) / vn.y ;

						m_pVtxBuffer->Unlock();
						return fReturnNum;

					}
				}

			}

			//̎Op`Ƃ
			p0 = pVtx[ (int)GetSheet().x * ( nTate ) + nYoko +1 ].pos;
			p1 = pVtx[ (int)GetSheet().x * ( nTate +1 ) + nYoko +1 ].pos;
			p2 = pVtx[ (int)GetSheet().x * ( nTate ) + nYoko ].pos;
			v01 = p1 - p0;
			v0p = pos - p0;

			D3DXVec3Cross( &vC0 , &v01 , &v0p );

			//px
			if( vC0.y >= 0.0f )
			{
				v12 = p2 - p1;
				v1p = pos - p1;
				D3DXVec3Cross( &vC1 , &v12 , &v1p );

				if( vC1.y >= 0.0f )
				{
					v20 = p0 - p2;
					v2p = pos- p2;
					D3DXVec3Cross( &vC2 , &v20 , &v2p );

					//܂ł璆Ă܁[
					if( vC2.y >= 0.0f )
					{
						D3DXVec3Cross( &vn , &v01 , &v20 );
						D3DXVec3Normalize( &vn , &vn );

						fReturnNum = p0.y - ( ( pos.x - p0.x ) * vn.x + ( pos.z - p0.z ) * vn.z ) / vn.y ;

						m_pVtxBuffer->Unlock();
						return fReturnNum;

					}
				}

			}
		}	
	}

	return fReturnNum;
}